--[[---------------------------------------------------------------------------
	Chocolatier Two Ingredient/Product Data
	Copyright (c) 2006-2007 Big Splash Games, LLC. All Rights Reserved.
--]]---------------------------------------------------------------------------

bsgLoadStringFile("item/item_strings.xml")

-- PRODUCT TYPES --------------------------------------------------------------

DefineProductType
{
	name = "square",
	trayEnd = 0.98,
	traypath = { {525,300},{525,225},{525,155},{525,80},
					{375,80},{230,80},{80,80},
					{80,220},{80,360},{80,500},
					{230,500},{375,500},{525,500},
					{525,430},{525,370},{525,300},
					},
	ingredientpath = { {0,570},{20,570},{280,570},{300,570},{300,550},{300,320},{300,300}, },
	productpath = { {689,300},{689,320},{689,500},{689,555}, },
	traycount = 7,
	colorcount = 2,
	markup = 1.55,
	handicap = .9,
}

DefineProductType
{
	name = "infusion",
	price = 49000,
	trayEnd = 0.99,
	traypath = { {525,300},{450,300},{455,150},{525,80},
					{455,150},{160,150},{80,80},
					{160,150},{160,430},{80,500},
					{160,430},{455,430},{525,500},
					{455,430},{450,300},{525,300},
					},
	ingredientpath = { {0,570},{20,570},{280,570},{300,570},{300,550},{300,320},{300,300}, },
	productpath = { {689,300},{689,320},{689,500},{689,555}, },
	traycount = 7,
	colorcount = 2,
	markup = 1.7,
	handicap = .8,
}

DefineProductType
{
	name = "sauce",
	price = 380000,
	trayEnd = 0.98,
	traypath = { {525,300},{525,150},{450,75},{300,75},{150,75},{75,150},{75,300},{75,450},{150,525},{300,525},{450,525},{525,450},{525,300}, },
	ingredientpath = { {0,570},{20,570},{280,570},{300,570},{300,550},{300,320},{300,300}, },
	productpath = { {689,300},{689,320},{689,500},{689,555}, },
	traycount = 7,
	colorcount = 3,
	markup = 1.77,
	handicap = 1.15,
}

DefineProductType
{
	name = "praline",
	trayEnd = 0.97,
	price = 625000,
	traypath = { {-75,80},{231,80},{553,29},{522,167},
				{489,310},{65,189},{75,290},
				{109,525},{236,491},{421,449},
				{499,421},{519,293},{658,300}, },
	ingredientpath = { {0,596},{115,455},{504,597},{591,520}, },
	productpath = { {689,300},{689,320},{689,500},{689,555}, },
	traycount = 8,
	colorcount = 2,
	markup = 1.8,
	handicap = 1.22,
}

DefineProductType
{
	name = "truffle",
	price = 850000,
	trayEnd = 0.99,
	traypath = { {525,300},{450,300},{455,150},{525,80},
					{455,150},{160,150},{80,80},
					{160,150},{160,430},{80,500},
					{160,430},{455,430},{525,500},
					{455,430},{450,300},{525,300},
					},
	ingredientpath = { {0,570},{20,570},{280,570},{300,570},{300,550},{300,320},{300,300}, },
	productpath = { {689,300},{689,320},{689,500},{689,555}, },
	traycount = 7,
	colorcount = 2,
	markup = 1.86,
	handicap = 1.25,
}

DefineProductType
{
	name = "exotic",
	price = 1350000,
	trayEnd = 0.98,
	traypath = { {525,300},{525,150},{450,75},{300,75},{150,75},{75,150},{75,300},{75,450},{150,525},{300,525},{450,525},{525,450},{525,300}, },
	ingredientpath = { {0,570},{20,570},{280,570},{300,570},{300,550},{300,320},{300,300}, },
	productpath = { {689,300},{689,320},{689,500},{689,555}, },
	traycount = 7,
	colorcount = 3,
	markup = 2,
	handicap = 1.28,
}

-- BASIC INGREDIENTS ----------------------------------------------------------
DefineItem { "sugar", low = 25, high = 39, type="it_basic" }
DefineItem { "milk", low = 54, high = 81, type="it_basic" }
DefineItem { "cacao", low = 47, high = 128, type="it_cacao" }
DefineItem { "caramel", low = 145, high = 391, type="it_basic" }

-- NUTS -----------------------------------------------------------------------
DefineItem { "almond", low = 44, high = 104, type="it_nut" }
DefineItem { "cashew", low = 61, high = 130, type="it_nut" }
DefineItem { "hazelnut", low = 578, high = 760, type="it_nut" }
DefineItem { "macadamia", low = 842, high = 1405, type="it_nut" }
DefineItem { "pecan", low = 588, high = 744 , startWeek = 34, endWeek = 49, type="it_nut" }

-- FRUITS  --------------------------------------------------------------------
DefineItem { "coconut", low = 161, high = 339, type="it_fruit" }
DefineItem { "raspberry", low = 195, high = 501, startWeek = 21, endWeek = 35, type="it_fruit"  }
DefineItem { "cherry", low = 572, high = 776 , startWeek = 23, endWeek = 30, type="it_fruit" }
DefineItem { "lemon", low = 95, high = 125, type="it_fruit" }
DefineItem { "orange", low = 178, high = 297, type="it_fruit" }
DefineItem { "mango", low = 3283, high = 4700, startWeek = 13, endWeek = 38, type="it_fruit"  }

-- FLAVORS --------------------------------------------------------------------
DefineItem { "vanilla", low = 483, high = 1005, type="it_flavor" }
DefineItem { "coffee", low = 300, high = 725, type="it_flavor" }
DefineItem { "mint", low = 240, high = 390, type="it_flavor" }
DefineItem { "cinnamon", low = 1628, high = 4006, type="it_flavor" }
DefineItem { "pepper", low = 1400, high = 2770, type="it_flavor" }
DefineItem { "ginger", low = 1677, high = 2951, startWeek = 43, endWeek = 12, type="it_flavor"  }
DefineItem { "cognac", low= 2574 , high= 4444, type="it_flavor" }

-- SPECIALTY CACAOS ------------------------------------------------------------------
DefineItem { "ma_cacao", low=479, high = 1323, type="it_cacao" }
DefineItem { "sj_cacao", low= 284, high= 1274, type="it_cacao" }
DefineItem { "ca_cacao", low= 380 , high= 620, type="it_cacao" }
DefineItem { "ab_cacao", low= 145 , high= 782, type="it_cacao" }
DefineItem { "ja_cacao", low= 421 , high= 800, type="it_cacao" }
DefineItem { "ph_cacao", low= 567 , high= 2133, type="it_cacao" }

-- POWDER FOR TRUFFLES   --------------------------------------------------------
DefineItem { "powder", low= 875 , high= 1589, type="it_basic" }

-- FLOWERS  --------------------------------------------------------

DefineItem { "orchid", low= 10800 , high= 16247, type="it_flower" }
DefineItem { "rose", low= 1107 , high= 1407, type="it_flower" }
DefineItem { "carnation", low= 225 , high= 312, type="it_flower" }
DefineItem { "tulip", low= 536 , high= 847, type="it_flower" }

-- SECRET INGREDIENTS  --------------------------------------------------------
DefineItem { "ant", low= 587, high= 884, type="it_secret" }
DefineItem { "plantain", low= 896 , high= 2275, type="it_secret" }
DefineItem { "currant", low = 1445, high = 2661, type="it_secret" }
DefineItem { "anise", low = 975, high = 3620, type="it_secret" }
DefineItem { "clove", low = 1280, high = 2337, type="it_secret" }
DefineItem { "tea", low= 2078 , high= 6082, type="it_secret" }
DefineItem { "lavender", low = 6925, high = 9938, type="it_secret" }
DefineItem { "saffron", low = 7985, high = 13300, type="it_secret" }
DefineItem { "pumpkin", low = 2351, high = 8847, startWeek = 34, endWeek = 46, type="it_secret" }
DefineItem { "berry", low= 7022 , high= 11028, startWeek = 28, endWeek = 38, type="it_secret" }


-- 2 and 3-INGREDIENT SQUARES -------------------------------------------------------------------
				
DefineItem { "b_01", type = "square",
				-- For this recipe only, VERY simple
				trayEnd = 0.95,
				traypath = { {-75,300},{166,8},{490,361},{658,300}, },
				ingredientpath = { {0,570},{20,570},{280,570},{300,570}, },
				productpath = { {689,300},{689,320},{689,500},{689,555}, },
				traycount = 5,
				colorcount = 0,
				recipe = { sugar = 1, cacao = 1 } }				
DefineItem { "b_02", type = "square",
				recipe = { sugar = 1, cacao = 2} }	
DefineItem { "b_03", type = "square",
				recipe = { sugar = 1, cacao = 1, milk = 1 } }	
DefineItem { "b_04", type = "square",
				recipe = { sugar = 1, cacao = 1, almond = 1 } }							
DefineItem { "b_05", type = "square",
				recipe = { sugar = 1, cacao = 1, cashew = 1 } }
DefineItem { "b_06", type = "square",
				recipe = { sugar = 1, cacao = 1, coffee = 1 } }				
DefineItem { "b_07", type = "square",
				recipe = { sugar = 1, cacao = 1, orange = 1 } }				
DefineItem { "b_08", type = "square",
				recipe = { sugar = 1, cacao = 1, lemon = 1 } }
DefineItem { "b_09", type = "square",
				recipe = { sugar = 1, cacao = 1, raspberry = 1 } }				
DefineItem { "b_10", type = "square",
				recipe = { sugar = 1, cacao = 1, hazelnut = 1 } }
DefineItem { "b_11", type = "square",
				recipe = { sugar = 1, cacao = 1, pecan = 1 } }			
DefineItem { "b_12", type = "square", lab=true, markup = 1.65,
				recipe = { sugar = 1, cacao = 1, ant = 1 } }		


-- 4-INGREDIENT INFUSIONS -------------------------------------------------------------------
				
DefineItem { "i_01", type = "infusion",
				recipe = { sugar = 1, cacao = 3 } }				
DefineItem { "i_02", type = "infusion",
				recipe = { sugar = 1, cacao = 2, mint = 1 } }	
DefineItem { "i_04", type = "infusion",
				recipe = { sugar = 1, cacao = 2, pecan = 1 } }								
DefineItem { "i_05", type = "infusion",
				recipe = { sugar = 1, cacao = 2, raspberry = 1 } }
DefineItem { "i_07", type = "infusion", 
				recipe = { sugar = 1, cacao = 1, milk = 1, almond = 1 } }				
DefineItem { "i_08", type = "infusion",
				recipe = { sugar = 1, cacao = 1, milk = 1, cashew = 1 } }
DefineItem { "i_09", type = "infusion",
				recipe = { sugar = 1, cacao = 1, almond = 1, caramel = 1 } }
DefineItem { "i_10", type = "infusion",
				recipe = { sugar = 1, ab_cacao = 2, orange = 1 } }		
DefineItem { "i_11", type = "infusion", 
				recipe = { sugar = 1, sj_cacao = 2, hazelnut = 1 } }				
DefineItem { "i_12", type = "infusion", 
				recipe = { sugar = 1, ca_cacao = 2, pepper = 1 } }
DefineItem { "i_03", type = "infusion", lab=true, markup = 1.72,
				recipe = { sugar = 1, cacao = 2, anise = 1 } }	
DefineItem { "i_06", type = "infusion", lab=true, markup = 1.73,
				recipe = { sugar = 1, cacao = 2, plantain = 1 } }
				
		
-- 4-INGREDIENT SAUCES -------------------------------------------------------------------
				
DefineItem { "s_01", type = "sauce",
				recipe = { sugar = 1, cacao = 2, milk = 1 } }				
DefineItem { "s_02", type = "sauce",
				recipe = { sugar = 1, cacao = 1, milk = 1, raspberry = 1 } }
DefineItem { "s_03", type = "sauce",
				recipe = { sugar = 1, cacao = 1, milk = 1, cherry = 1 } }
DefineItem { "s_04", type = "sauce",
				recipe = { sugar = 1, cacao = 1, milk = 1, coffee = 1 } }									
DefineItem { "s_06", type = "sauce", 
				recipe = { sugar = 1, cacao = 1, milk = 1, ginger = 1 } }					
DefineItem { "s_07", type = "sauce",
				recipe = { sugar = 1, milk = 1, caramel = 2 } }					
DefineItem { "s_11", type = "sauce",
				recipe = { sugar = 1, ca_cacao = 1, cacao = 1, pepper = 1 } }
DefineItem { "s_10", type = "sauce",
				recipe = { sugar = 1, ca_cacao = 2, milk = 1 } }			
DefineItem { "s_12", type = "sauce",
				recipe = { sugar = 1, ma_cacao = 1, milk = 1, cognac = 1 } }	
DefineItem { "s_05", type = "sauce", lab=true, markup = 1.79,
				recipe = { sugar = 1, cacao = 1, milk = 1, saffron = 1 } }	
DefineItem { "s_08", type = "sauce", lab=true, markup = 1.78,
				recipe = { sugar = 1, cacao = 2, currant = 1 } }	
DefineItem { "s_09", type = "sauce", lab=true, markup = 1.78,
				recipe = { sugar = 1, ab_cacao = 2, plantain = 1 } }
	

								
-- 5-INGREDIENT PRALINES -------------------------------------------------------------------
				
DefineItem { "p_01", type = "praline",
				recipe = { sugar = 1, cacao = 4 } }				
DefineItem { "p_02", type = "praline",
				recipe = { sugar = 1, cacao = 2, milk = 2 } }	
DefineItem { "p_03", type = "praline",
				recipe = { sugar = 1, cacao = 2, milk = 1, almond = 1 } }	
DefineItem { "p_04", type = "praline",
				recipe = { sugar = 1, cacao = 2, mint = 1, coffee = 1 } }								
DefineItem { "p_05", type = "praline",
				recipe = { sugar = 1, cacao = 2, orange = 1, cognac = 1 } }
DefineItem { "p_07", type = "praline",
				recipe = { sugar = 1, cacao = 2, hazelnut = 1, caramel = 1 } }
DefineItem { "p_09", type = "praline",
				recipe = { sugar = 1, sj_cacao = 2, mango = 1, lemon = 1 } }
DefineItem { "p_06", type = "praline", lab = true, markup = 1.85,
				recipe = { sugar = 1, cacao = 2, raspberry = 1, anise = 1 } }								
DefineItem { "p_08", type = "praline", lab=true, markup = 1.86,
				recipe = { sugar = 1, ma_cacao = 2, vanilla = 1, clove = 1 } }				
DefineItem { "p_10", type = "praline", lab=true, markup = 1.87,
				recipe = { sugar = 1, ja_cacao = 1, ginger = 1, pumpkin = 1, macadamia =1, } }	
DefineItem { "p_11", type = "praline", lab=true, markup = 1.89,
				recipe = { sugar = 1, sj_cacao = 1, ca_cacao = 1, ma_cacao = 1, currant = 1 } }				
DefineItem { "p_12", type = "praline", lab=true, markup = 1.89,
				recipe = { sugar = 1, ab_cacao = 1, sj_cacao = 1, cinnamon = 1, lavender = 1 } }
							


-- 6-INGREDIENT TRUFFLES -------------------------------------------------------------------
				
			
DefineItem { "t_02", type = "truffle",
				recipe = { sugar = 2, cacao = 3 , powder = 1} }		
DefineItem { "t_03", type = "truffle",
				recipe = { sugar = 2, cacao = 1 , milk = 2, powder = 1} }	
DefineItem { "t_04", type = "truffle",
				recipe = { sugar = 1, cacao = 2 , coconut = 1, almond = 1, powder = 1} }
DefineItem { "t_01", type = "truffle", markup = 4,
				recipe = { sugar = 2, cacao = 2 , pepper = 1, powder = 1} }									
DefineItem { "t_07", type = "truffle",
				recipe = { sugar = 1, ph_cacao = 3 , milk = 1, powder = 1} }			
DefineItem { "t_09", type = "truffle",
				recipe = { sugar = 1, ca_cacao = 1, sj_cacao = 1, ja_cacao = 1, ginger = 1 , powder = 1} }					
DefineItem { "t_05", type = "truffle", lab=true, markup = 1.91,
				recipe = { sugar = 1, cacao = 2 , lavender = 1, macadamia = 1, powder = 1} }
DefineItem { "t_11", type = "truffle", lab=true, markup = 1.97,
				recipe = { sugar = 1, ca_cacao = 1, sj_cacao = 1, ma_cacao = 1, tea = 1 , powder = 1} }				
DefineItem { "t_06", type = "truffle", lab=true, markup = 1.95,
				recipe = { sugar = 1, ja_cacao = 2 , cherry = 1, anise = 1, powder = 1} }		
DefineItem { "t_08", type = "truffle", lab=true, markup = 1.92,
				recipe = { sugar = 1, currant = 1, ab_cacao = 1 , ma_cacao = 2, powder = 1} }
DefineItem { "t_10", type = "truffle", lab=true, markup = 1.98,
				recipe = { sugar = 1, ma_cacao = 1, ph_cacao = 1, ja_cacao = 1, pumpkin = 1 , powder = 1} }
DefineItem { "t_12", type = "truffle", lab=true, markup = 1.98,
				recipe = { sugar = 1, ph_cacao = 1, sj_cacao = 1, ca_cacao = 1, berry = 1, powder = 1} }				

				
-- 5-INGREDIENT EXOTICS -------------------------------------------------------------------
				
DefineItem { "e_01", type = "exotic",
				recipe = { sugar = 1, milk = 1 , cacao = 1, lemon = 1, ginger=1 } }				
DefineItem { "e_02", type = "exotic", lab=true,
				recipe = { sugar = 1, cacao = 2 , coffee = 1, saffron=1 } }		
DefineItem { "e_03", type = "exotic", lab=true,
				recipe = { sugar = 1, cacao = 2 , pepper = 1, currant = 1} }	
DefineItem { "e_04", type = "exotic", lab=true,
				recipe = { sugar = 1, ja_cacao = 1 , ma_cacao = 1 , mango = 1, plantain = 1} }								
DefineItem { "e_05", type = "exotic", lab=true, markup = 4.36,
				recipe = { sugar = 1, ja_cacao = 1 , plantain = 1, coconut = 1, ant = 1} }
DefineItem { "e_06", type = "exotic", lab=true,
				recipe = { sugar = 1, cacao = 1 , clove = 1, ginger = 1, anise = 1} }		
DefineItem { "e_07", type = "exotic", lab=true,
				recipe = { ma_cacao = 1, ca_cacao = 1, ab_cacao = 1, ph_cacao = 1, ja_cacao = 1,} }			
DefineItem { "e_08", type = "exotic", lab=true,
				recipe = { sugar = 1, sj_cacao = 1 , ma_cacao = 1, anise = 1, orange = 1} }
DefineItem { "e_09", type = "exotic", lab=true,
				recipe = { sugar = 1, ma_cacao = 1, ab_cacao = 1, lavender = 1 , caramel = 1} }					
DefineItem { "e_10", type = "exotic", lab=true,
				recipe = {  sugar = 1, ab_cacao = 2, pecan = 1 , tea = 1} }
DefineItem { "e_11", type = "exotic", lab=true,
				recipe = {  sugar = 1, ca_cacao = 1, pumpkin = 1, macadamia = 1 , powder = 1} }				
DefineItem { "e_12", type = "exotic", lab=true,
				recipe = {  sugar = 1, sj_cacao = 1, ph_cacao = 1, ma_cacao = 1, berry = 1} }
				
				



				
--[[
-- JON'S EXPERIMENTAL LAYOUTS

-- Gentle wave left to right, almost straight
traypath = { {4294967221,300},{166,8},{490,361},{700,300}, },
ingredientpath = { {0,570},{20,570},{280,570},{300,570}, },
productpath = { {700,300},{700,320},{700,500},{700,520}, },

-- Circular Choco I style
traypath = { {525,300},{525,150},{450,75},{300,75},{150,75},{75,150},{75,300},{75,450},{150,525},{300,525},{450,525},{525,450},{525,300}, },
ingredientpath = { {0,570},{20,570},{280,570},{300,570},{300,550},{300,320},{300,300}, },
productpath = { {700,300},{700,320},{700,500},{700,520}, },

-- Square
traypath = { {525,300},{525,225},{525,155},{525,80},
				{375,80},{230,80},{80,80},
				{80,220},{80,360},{80,500},
				{230,500},{375,500},{525,500},
				{525,430},{525,370},{525,300},
				},
ingredientpath = { {0,570},{20,570},{280,570},{300,570},{300,550},{300,320},{300,300}, },
productpath = { {700,300},{700,320},{700,500},{700,520}, },	

-- Altered square: more clover-like
traypath = { {525,300},{450,300},{455,150},{525,80},
				{455,150},{160,150},{80,80},
				{160,150},{160,430},{80,500},
				{160,430},{455,430},{525,500},
				{455,430},{450,300},{525,300},
				},
ingredientpath = { {0,570},{20,570},{280,570},{300,570},{300,550},{300,320},{300,300}, },
productpath = { {700,300},{700,320},{700,500},{700,520}, },

-- Left to Right Arc
traypath = { {39,461},{34,343},{58,259},{99,182},{175,105},{267,77},{362,75},{490,77},{610,133},{684,202},{742,283},{765,371},{770,471}, },
ingredientpath = { {1,553},{75,550},{143,549},{207,548},{279,547},{330,546},{401,545}, },
productpath = { {781,483},{780,518},{779,549},{779,586}, },

-- Left to right up and around curve
traypath = { {77,675},{77,448},{41,77},{224,79},{532,82},{417,402},{875,338}, },
ingredientpath = { {1,565},{67,565},{146,566},{211,565},{410,563},{473,593},{457,478}, },
productpath = { {777,338},{777,400},{777,521},{777,553}, },

-- Snaking from upper left
traypath = { {0,80},{231,80},{553,29},{522,167},
			{489,310},{65,189},{75,290},
			{109,525},{236,491},{421,449},
			{499,421},{519,293},{700,300}, },
ingredientpath = { {0,596},{115,455},{504,597},{591,520}, },
productpath = { {700,300},{700,320},{700,500},{700,520}, },

]]--
